<html>
<head>
	<style type="text/css">
		@import "style.css";
	</style>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<title>Delta file output</title>
</head>

<body>

<?php
function getTextInLanguage( $array, $name, $tag)
{
	global	$lang;

	foreach( $array->$name as $item)
	{
		if( $item['language'] == "$lang" )
			return utf8_decode($item[$tag]);
	}

	return '';
}

function parseXMLcoding($string)
{
    if ( strlen($string) == 0 )
        return $string;

    $string = preg_split("//", $string, -1, PREG_SPLIT_NO_EMPTY);

    for ( $i = 0; $i < count($string); $i++ )
    {
/*      $dec = ord($string[$i]);

        if ( $dec > 127 )
            $string[$i] = '&#' . $dec . ';';
        else
 */
        if( $string[$i] == '>' )
            $string[$i] = '&gt;';
        else if( $string[$i] == '<' ) //'
            $string[$i] = '&lt;';
        else if( $string[$i] == '&' )
            $string[$i] = '&amp;';
        else if( $string[$i] == "'" )
            $string[$i] = '&quot;';
    }

    return implode('',$string);
}

function writeLog( $line)
{
	global $file_log;

	fwrite( $file_log, "$line\n") or
		die( "Error - char.log file couldn't be written with: line");
}

function getComment( $node, $pos, $lang)
{
	foreach( $node->comment as $comment)
	{
		if( $comment['position'] == "$pos" && $comment['lang'] == "$lang")
		{
			$text= $comment['label'];
			return( "<$text>");
		}
	}

	return('');
}

// ** here starts the script ** //

	$fName= 'delta.xml';
	$groupTag= 'char-group';
	$subgroupTag= 'char-subgroup';
	$charTag= 'character';
	$stateTag= 'state';
	$attrTag= 'attribute';
	$delimText= array( 'up to'  => '-', 'or' => '/', 'and' => '&');

	$file_log= fopen( "xml2delta.log","w") or
		die( "Error - xml2delta.log description file couldn't be openend");

	if( !file_exists($fName) )
		die( "<p align='center'>File '$fName' not found</p>");
	else
		$xml = simplexml_load_file($fName) or die ("Unable to load '$fName' file!");

//	echo $xml->asXML();	// ** output is the full xml structure ** //
	$character_list= $xml->character_list;
	$item_list= $xml->item_list;

//	print_r($xml);
//	var_dump($xml);

	if( $_REQUEST['language'])
		$lang= $_REQUEST['language'];
	else
		$lang= $character_list['language'];

	echo "<hr><h2>Output language='$lang'<br><br>The chars file</h2><hr>";

	if( $character_list['description'] != '')
		echo "*SHOW: ".$character_list['description'].". Revised ".$character_list['revised']."<br><br>\n";
	echo "*CHARACTER LIST<br>\n";

	$typeCode= array( "real number"=>"RN",
		"ordered multi state"=>"OM",
		"unordered multi state"=>"UM",
		"integer number"=>"IN",
		"text"=>"TE");

//	echo $typeCode["integer number"]."<br>\n";

	foreach( $character_list->$groupTag as $group)	// ** read the character list	** //
	{
		$groupName= getTextInLanguage( $group, 'name', 'label');
		$first= TRUE;

		foreach( $group->$charTag as $char)
		{
			$nbr= (int)substr( $char['id'], 1);

			if( $first)
			{
				if( $group['style'] == "newParagraph")
					$newParagraph .= ' '.$nbr;
				$first= FALSE;
			}

			$type= $char['type'];
			$charType[$nbr]= $typeCode["$type"];
			$comment= getTextInLanguage( $char, 'comment', 'label');
			$prefix=  getTextInLanguage( $char, 'prefix', 'label');
			$postfix= getTextInLanguage( $char, 'postfix', 'label');

			if( $char['implicitState'])
				$charImplicitState[$nbr]= $char['implicitState'];

			if( $char['linkToChar'])
				$linkToChar[$nbr]= $char['linkToChar'];

			if( $char['states'])
				$charNbrStates[$nbr]= $char['states'];

			if( $char['reliable'])
				$charReliable[$nbr]= $char['reliable'];

			if( $char['inapplicableIf'])
				$inapplicable[$nbr]= substr( $char['inapplicableIf'], 1);

			if( !$firstNbrInGroup)
				$firstNbrInGroup= $nbr;

			if( !$comment)
				$comment= $char->comment['label'];

			if( $comment)
				echo "\n<br>$nbr. $groupName $prefix &lt;$comment&gt;/<br>\n";
			else
				echo "\n<br>$nbr. $groupName $prefix /<br>\n";

			if( $postfix)
				echo "&nbsp;&nbsp;$postfix /<br>\n";

			foreach( $char->$stateTag as $state)
			{
				$nbr= (int)$state['id'];
				$description= 	getTextInLanguage( $state, 'description', 'label');
				$comment= 		getTextInLanguage( $state, 'description', 'comment');

				if( $comment)
					echo "&nbsp;&nbsp;$nbr. $description &lt;$comment&gt;/<br>\n";
				else
					echo "&nbsp;&nbsp;$nbr. $description /<br>\n";
			}
		}
	}

//**** ITEMS FILE ****//

	echo '<hr><h2>The items file</h2><hr>';

	if( $item_list['description'] != '')
		echo "*SHOW: ".$item_list['description'].". Revised ".$item_list['revised']."<br><br>\n";
	echo "*ITEM DESCRIPTIONS<br>\n";

	foreach( $item_list->item as $item)	// ** read the item list	** //
	{
		if( $item['author'])
			echo "<br><br>\n\n#".$item['name']."<".$item['author'].">/";
		else
			echo "<br><br>\n\n#".$item['name']."/";

		if( $item['author'])
			echo ' <'.$item['author'].'>';
		echo "<br>\n";

		foreach( $item->$attrTag as $attr)
		{
			$attrText  = ' '.substr( $attr['id_ref'], 1);
			$addComma= TRUE;
			$attrText .= getComment( $attr, 'left', $lang);

			foreach( $attr->state as $state)
			{
				$logic= $state['logic'] ;
				$attrText .= $delimText["$logic"];
				$attrText .= getComment( $state, 'left', $lang);

				if( $addComma)
				{
					$addComma= FALSE;
					$attrText .= ',';
				}

				$attrText .= $state['value'];
				$attrText .= getComment( $state, 'right', $lang);
			}

 			echo parseXMLcoding($attrText);
 		}

	}

// ** write specs file **//
	echo '
<hr>
<h2>The specs file</h2>
<hr>';

if( $character_list['description'] != '')
	echo '*SHOW '.$character_list['description'].'. Revised '.$xml->character_list['revised'].'<br><br>\n';

if( $character_list['heading'] != '')
	echo "*HEADING ".$character_list['heading']."<br><br>\n";

echo '
*NUMBER OF CHARACTERS '.$xml->character_list['charsNbr'].'<br>
*MAXIMUM NUMBER OF STATES '.$xml->character_list['stateMax'].'<br>
*MAXIMUM NUMBER OF ITEMS '.$xml->item_list['itemsNbr'].'<br>
<br>
*CHARACTER TYPES ';

foreach( $charType as $nbr => $type)
{
	if( $type == $prevType)
		continue;

	if( $prevNbr && $prevType != 'UM')
	{
		if( $prevNbr < $nbr-1)
			echo "$prevNbr-".($nbr-1).",$prevType ";
		else
			echo "$prevNbr,$prevType ";
	}

	$prevNbr= $nbr;
	$prevType=$type;
}

if( $prevNbr < $nbr-1)
	echo "$prevNbr-".($nbr-1).",$prevType ";
else
	echo "$prevNbr,$prevType ";

echo "\n\n<br><br>*NUMBERS OF STATES  ";

foreach( $charNbrStates as $nbr => $states)
	if( $states != 2)
		echo "$nbr,$states ";

$prevNbr= 0;

if( $linkToChar)
{
	echo "\n\n<br><br>*LINK CHARACTERS  ";

	foreach( $linkToChar as $nbr => $linkTo)
	{
		if( (int)$linkTo == (int)$prevLinkTo)
		{
			$lastNbr= $nbr;
			continue;
		}

		if( $prevNbr)
		{
			echo "$prevLinkTo-$lastNbr ";
			$prevNbr= 0;
		}

		$prevNbr= $nbr;
		$prevLinkTo=$linkTo;
	}

	if( $prevNbr)
		echo "$prevLinkTo-$lastNbr ";
}

if( $newParagraph)
	echo "\n\n<br><br>*NEW PARAGRAPHS AT CHARACTERS $newParagraph";

if( $charReliable)
{
	echo "\n\n<br><br>*CHARACTER RELIABILITIES  ";

	foreach( $charReliable as $nbr => $reliable)
			echo "$nbr,$reliable ";
}

if($charImplicitState)
{
	echo "\n\n<br><br>*IMPLICIT VALUES  ";

	foreach( $charImplicitState as $nbr => $implicit)
			echo "$nbr,$implicit ";
}

if($inapplicable)
{
	echo "\n\n<br><br>*INAPPLICABLE CHARACTERS  ";
	$prevNbr= '';

	foreach( $inapplicable as $nbr => $rule)
	{
		if( $rule == $prevRule)
			continue;

		if( $prevNbr)
		{
			if( $prevNbr < $nbr-1)
				echo "$prevRule:$prevNbr-".($nbr-1)." ";
			else
				echo "$prevRule:$prevNbr ";
		}

		$prevNbr= $nbr;
		$prevRule=$rule;
	}

	if( $prevNbr && $prevNbr < $nbr-1)
		echo "$prevRule:$prevNbr-".($nbr-1)." ";
	else
		echo "$prevRule:$prevNbr ";
}

echo "\n\n<br><br>  ";
fclose( $file_log);


?>
</body>
</html>