<?php

function writeOut( $line)
{
	global $file_out;

	fwrite( $file_out, "$line\n") or
		die( "Error - char.xml file couldn't be written with: line");
}

function getStyle( $text)
{
	global $style;
	$text= ' '.$text;

	if( strpos( $text, '\i{}') > 0 )
	{
		$text=str_replace( '\i{}', '', $text);
		$text=str_replace( '\i0{}', '', $text);
		$style= 'italic';
	}

	return trim($text);
}

function writeLog( $line)
{
	global $file_log;

	fwrite( $file_log, "$line\n") or
		die( "Error - char.log file couldn't be written with: line");
}

function parseXMLcoding($string)
{
    if ( strlen($string) == 0 )
        return $string;

    $string = preg_split("//", $string, -1, PREG_SPLIT_NO_EMPTY);

    for ( $i = 0; $i < count($string); $i++ )
    {
/*      $dec = ord($string[$i]);

        if ( $dec > 127 )
            $string[$i] = '&#' . $dec . ';';
        else
 */
        if( $string[$i] == '>' )
            $string[$i] = '&gt;';
        else if( $string[$i] == '<' ) //'
            $string[$i] = '&lt;';
        else if( $string[$i] == '&' )
            $string[$i] = '&amp;';
        else if( $string[$i] == "'" )
            $string[$i] = '&quot;';
    }

    return implode('',$string);
}

function commentDefaultLanguage( $text)
{
	if( $text == '')
		return '';
	else
		writeLog( '- '.$text);

	if( $text[0]=='[' || strpos( $text, '[') )
	{
		$array= explode( '[', $text);

		if( count( $array) >2)
			die( "Text with to many brackets []: $text");

		$returnValue= trim( array_shift( $array) );
		$array= explode( ']', $array[0]);
		$returnValue .= ' '.$array[1];
	}
	else
		$returnValue= $text;

	$returnValue = str_replace( '< >', '', $returnValue);

	writeLog( "Comment Default Language = '$returnValue'");
	return( parseXMLcoding( trim($returnValue) ) );
}

function bracketedComment( $text)
{
	if( $text[0]=='[' || strpos( $text, '[') )
	{
		$array= explode( '[', $text);

		if( count( $array) >2)
			die( "Text with to many brackets []: $text");

		array_shift( $array);
		$array= explode( ']', $array[0]);
		$returnValue= trim( array_shift( $array) );
	}
	else
		$returnValue= '';

//	writeLog( "Bracketed($text)= $returnValue");
	return( parseXMLcoding( trim($returnValue) ) );
}

function writeTabs( $nbr)
{
	global $file_out;

	while( $nbr--)
		fwrite( $file_out, "\t");
}

function writeOutLevel( $level, $string)
{
	writeTabs( $level);
	writeOut( $string);
}

function writeComment( $level, $pos)
{
	global $comment, $defaultLang, $bracketedLang, $langTag;

	$currentComment= array_shift( $comment);
	$default= commentDefaultLanguage( $currentComment );
	$bracketed= bracketedComment( $currentComment );

	if( $default)
		writeOutLevel( $level, "<comment $langTag='$defaultLang' position='$pos' label='$default' />");

	if( $bracketed)
		writeOutLevel( $level, "<comment $langTag='$bracketedLang' position='$pos' label='$bracketed' />");
}

function replaceComment( $data)
{
	global $comment;

	while( $data[0] == '<' || $start= strpos( $data, '<') ) 		//'
	{
		if( $data[0] == '<' )
		{
			$start= 0;
			$returnStr .= '@';
		}
		else
			$returnStr .= substr( $data, 0, $start).'@';

		$end= strpos( $data, '>') or die( "Error: no closing delimmiter for comment: $data");
		$comment[$i]= substr( $data, $start+1, $end-$start-1);

		if( $comment[$i][0]=='<'|| strpos( $comment[$i], '<') )	//** comment in comment situation
		{
			writeLog( "Comment in comment situation: '".$comment[$i]." search '>' in ".substr($data, $end+1 ));

			if( $data[$end+1] == '>' )
				$offset= 0;
			else
				$offset= strpos( substr($data, $end+1 ), '>') or die( "Error: no closing delimmiter for SUB comment: ".substr($data, $end ));

			$end += $offset + 1;
			$comment[$i]= substr( $data, $start+1, $end-$start-1);
		}

		$data= substr( $data, $end + 1);
		writeLog( "Comment($start): '".$comment[$i]."' <** Rest **> ".substr($data, 0, 50)." ..");

		$i++;
	}

	$returnStr .= $data;
	writeLog( "** Return: '$returnStr'");
	return $returnStr;
}


function getDelimiter( $rest)
{
	global $delimiter;

	if( $rest[0] == '(')
	{
		$delimiter= $rest[1];
		$rest[1]= '(';
	}
	else
		$delimiter= $rest[0];

	writeLog( "Delimiter: '$delimiter' and rest '".substr( $rest, 1)."'");

	if( strlen($rest) > 1)
	{
		if( $rest[1] == ')')
			return substr( $rest, 2);
		else
			return substr( $rest, 1);
	}
	else
		return '';
}


function getState( $rest)
{
	global $state;
	$len= strlen( $rest);

	if( $rest[0] == '-')
	{
		$state= '0';
		return $rest;
	}

	if( $rest[0] == '(' )
	{
		if( $pos= strpos( $rest, ')' ) )
		{
			$extreme= TRUE;
			$rest = substr( $rest, 1);
		}
		else
			die( "opening bracket without closing one: $rest");
	}
	else
		$extreme= FALSE;

	for( $i=0; $i < $len; $i++)
	{
		if( $rest[$i] == '-' || $rest[$i] == '/' || $rest[$i] == '&'  ||
			$rest[$i] == '(' || $rest[$i] == ')' || $rest[$i] == '@' )
			break;
	}

	if( $i == 0)
		die( "GetState doesn't start with a numeric state value: '$rest'");

	if( $extreme)
		$state= '('.substr( $rest, 0, $i).')';
	else
		$state= substr( $rest, 0, $i);

	writeLog( "GetState from '$rest' ='$state' has delimiter '".$rest[$i]."' on pos $i, return'".substr( $rest, $i)."'");

	if( strlen( substr( $rest, $i) ))
		return substr( $rest, $i);
	else
		return '';
}

// ********** here it starts 	*********** //
include 'readSpecs.php';
include "tags.php";

	$fName= 'delta.xml';

	if( $_REQUEST['lang'] != '')
		$defaultLang= $_REQUEST['lang'];
	else if( $_REQUEST['language'] != '')
		$defaultLang= $_REQUEST['language'];
	else
		$defaultLang= 'en';

	if( $_REQUEST['bracketed'])
		$bracketedLang= $_REQUEST['bracketed'];
	else
		$bracketedLang= 'en';

	$bracketed= $_REQUEST['bracketed'];

	echo "<html><body>
	DELTA char to xml conversion version 1.3 beta<br>
	Default Language = $defaultLang<br>";

	$file_out= fopen( $fName,"w") or
		die( "Error - char.xml description file couldn't be openend");

	$file_log= fopen( "delta2xl.log","w") or
		die( "Error - char.log description file couldn't be openend");


	$types= array( 'TE'=>'text', 'RN'=>'real number', 'IN'=>'integer number', 'OM'=>'ordered multi state', 'UM'=>'unordered multi state');
	readSpecs( );
	$data=file('chars');

	//** HEADER CHARS
	//**
	do
	{
		$line= trim( $data[0]);

		if( $line=='' || $line[0]=='*')
		{
			array_shift( $data);
			writeLog( "Header line: $line");
		}
		else
			writeLog( "Non Header line: '$line'");

		if( strpos( $line, 'SHOW') )
		{
			$array= explode( '.', $line);
			$projectDescription= trim(substr( $array[0], 5) );

			if( strpos( $array[1], 'Revised ') )
				$revised= trim(substr( $array[1], 8) );
		}
	}
	while( $data[0][0] != '#');

	writeOut("<?xml version='1.0' encoding='ISO-8859-1' ?>
<DELTA_data>

<vocabulary lang='en' operators='or,to,and,variable,unknown,inapplicable,
	variant,not coded,never,minimum,maximum,up to,or more'>
</vocabulary>
<vocabulary lang='es' operators='o,a,Y,variable,unknown,inapplicable,
	variant,not coded,never,minima,maxima,a, o mas'>
</vocabulary>

<$charListTag description='$projectDescription'
	heading ='".$specs['HEADING']."'
	charsNbr='".$specs['NUMBER OF CHARACTERS']."'
	stateMax='".$specs['MAXIMUM NUMBER OF STATES']."'
	$langTag='$defaultLang' revised='$revised'>");

	//** PUT each CHAR in an array
	//**
	foreach( $data as $line)
	{
		$line= trim($line);

		if( $line == '')
			continue;
		else if( $line[0]=='#')
		{
			if( $nbr)
				writeLog( $nbr.'. '.$list[$nbr] );

			$array= explode( '. ', $line);
			$nbr= (int)substr( array_shift( $array), 1);
			$list[$nbr] .= ' '.trim( implode( '. ', $array) );
		}
		else
			$list[$nbr] .= ' '.trim( $line);
	}

	echo "$nbr characters read, with the following character groups:<br>\n";
	$prevName= "nothing yet";
	writeLog( "Set new paragraphs at: ".$specs['NEW PARAGRAPHS AT CHARACTERS']);
	$groupNbr= 0;

	//** FOR EACH CHAR in list
	//**
	foreach( $list as $nbr => $line)
	{
		$line= rtrim($line, '/');

		$charStates= explode( "/ ", $line);						//* isolate character states
		$array= explode( "<", array_shift( $charStates) ); 		//*"remove comment part from array
		$nbrComm= count( $array) - 1;
		$startComment = "";
		$nameArray = array();

		if( trim($array[0]) == '' )								//* char starting with comment
		{
			array_shift( $array );

			if( $nbrComm > 1)									//* more comments in line
			{
				$pos= strpos( $array[0], '>');
				$startComment = "<".substr( $array[0], 0, $pos+1)." ";	//"
				$array[0] = trim( substr( $array[0], $pos+1) );
				writeLog( "CHAR more than 1 comment and starting with comment: '$startComment'");
				$nameArray = explode( " ",  trim( array_shift( $array ) ) );
				$nameArray[0] = $startComment.$nameArray[0];
			}
		}
		else
			$nameArray = explode( " ",  trim( array_shift( $array ) ) );

		$rest = rtrim( implode( "<", $array), "> ");			//* remove last bracket
		$charComment= commentDefaultLanguage( $rest );
		$charName= parseXMLcoding( rtrim( array_shift($nameArray) ));

		if( $charName == 'the')
			$charName .= ' '.parseXMLcoding( rtrim( array_shift($nameArray) ));

		$charPrefix= commentDefaultLanguage( implode( ' ', $nameArray ) );

		$bracketedArray= explode( " ", bracketedComment( $rest) );
		$charBracketed= parseXMLcoding( trim( array_shift($bracketedArray) ) );
		$prefixBracketed= parseXMLcoding( implode( ' ', $bracketedArray) );

		if( $charName != $prevName)
		{
			if( $prevName != 'nothing yet')
				writeOut( "</$groupTag>");

			$groupNbr++;
			$gNbr= sprintf( "%03d", $groupNbr);
			$subheading= parseXMLcoding( $subheadings[$nbr]);

			if( strstr( $specs['NEW PARAGRAPHS AT CHARACTERS'], ' '.$nbr.' ') != FALSE)
				$directives= "style='newParagraph'";
			else
				$directives= "";

			writeOut( "<$groupTag id='g$gNbr' $directives>");

			if( $charName != '')
				writeOut( "\t<name $langTag='$defaultLang' label='$charName' />");

			if( $charBracketed != '')
				writeOut( "\t<name $langTag='$bracketedLang' label='$charBracketed' />");

			if( $subheading)
				writeOut( "\t<subheading $langTag='$defaultLang' label='$subheading' />");

			echo "<li>$charName ($nbr)<br>\n";
			writeLog( "New group at $prevName to $charName (char $nbr) with subheading: ".$subheadings[$nbr]);
			$prevName= $charName;
		}

		if( $type[$nbr])
			$directives= "type='".$types[$type[$nbr]]."' ";
		else
			$directives= "type='".$types['UM']."' ";

		if( $link[$nbr] && $link[$nbr] != $nbr)
			$directives .= "linkToChar='".$link[$nbr] ."' ";

		if( (int)$reliable[$nbr])
			$directives .= "reliable='".$reliable[$nbr] ."' ";

		if( (int)$implicit[$nbr])
			$directives .= "implicitState='".$implicit[$nbr]."' ";

		if( $inapplicable[$nbr] )
			$directives .= "inapplicableIf='".$inapplicable[$nbr]."' ";

		$cId= sprintf( "c%03d", $nbr);
		$char= "<$charTag id='$cId' $directives";

		if( $charStates[0] != '' && (int)$charStates[0] == (int)'' )
		{
			$postfix= array_shift($charStates);
			$charPostfix= commentDefaultLanguage( $postfix);
			$postfixBracketed= bracketedComment( $postfix);
		}
		else
			$charPostfix= $postfixBracketed= '';

		if( ($states= count( $charStates) ) == 0 )
			writeOut( "\t$char>");
		else
			writeOut( "\t$char states='$states' >");

		if( $charComment)
			writeOut( "\t\t<comment $langTag='$defaultLang' label='$charComment' />");
		if( $bracketedComment)
			writeOut( "\t\t<comment $langTag='$bracketedLang' label='$bracketedComment' />");

		if( $charPrefix)
			writeOut( "\t\t<prefix $langTag='$defaultLang' label='$charPrefix' />");
		if( $prefixBracketed)
			writeOut( "\t\t<prefix $langTag='$bracketedLang' label='$prefixBracketed' />");

		if( $charPostfix)
			writeOut( "\t\t<postfix $langTag='$defaultLang' label='$charPostfix' />");
		if( $postfixBracketed)
			writeOut( "\t\t<postfix $langTag='$bracketedLang' label='$postfixBracketed' />");

		if( ($states= count( $charStates) ) == 0 )
			writeOut( "\t</$charTag>");
		else
		{
			//** write states
			//**
			foreach( $charStates as $charState)
			{
				if( trim($charState) == '' )
					continue;

				$array= explode( ". ", $charState);		//* isolate state number	*//

				if( count( $array) > 1)
				{
					$stateNbr= (int)array_shift( $array);
					$charState= implode( ". ", $array);
				}
				else
					die( "Error - char number $nbr, state without number ($charState)");


				$pos= strpos( $charState, '>');

				if( $pos && strlen($charState) != $pos+1)
				{
					writeLog( "STATE COMMENT not at the end of state: $charState");
					$description= parseXMLcoding( $charState);
					$comment= '';
					$bracketedDescription= '';
				}
				else
				{
					$array= explode( "<", trim( $charState, " >") );
					$description= parseXMLcoding( array_shift( $array));
					$comment= commentDefaultLanguage( implode( "<", $array) ); //"
					$bracketedDescription= bracketedComment( implode( "<", $array) );
				}

				writeOut( "\t\t<$stateTag id='s$nbr,$stateNbr' value='$stateNbr'>");

				if( $description != '')
					writeOut( "\t\t\t<description $langTag='$defaultLang' label='$description' />");

				if( $bracketedLang && $bracketedDescription != '')
					writeOut( "\t\t\t<description $langTag='$bracketedLang' label='$bracketedDescription' />");

				if( $comment != '')
					writeOut( "\t\t\t<comment $langTag='$defaultLang' label='$comment' />");

				writeOut( "\t\t</$stateTag>");
			}

			writeOut( "\t</$charTag>");
		}

	}

	writeOut( "</$groupTag>\n</$charListTag>\n\n");
	$data=file('items');
	$list= array();
						// ****** ITEMS FILE 			******//
	do					// ** read away the directive lines **//
	{
		$line= trim( $data[0]);

		if( $line=='' || $line[0]=='*')
		{
			array_shift( $data);
			writeLog( "Header line: $line");
		}
		else
			writeLog( "Non Header line: '$line'");

		if( strpos( $line, 'SHOW') )
		{
			$array= explode( '.', $line);
			$description= trim(substr( $array[0], 5) );

			if( strpos( $array[1], 'Revised') )
				$revised= trim(substr( $array[1], 8) );
		}
	}
	while( $data[0][0] != '#');

	writeOut("<$itemListTag description='$projectDescription'
	itemsNbr='".$specs['MAXIMUM NUMBER OF ITEMS']."'
	$langTag='$defaultLang' revised='$revised'>");
	$nbr= 0;

	foreach( $data as $line)
	{
		$line= trim($line);

		if( $line == '')
			continue;
		else if( $line[0]=='#')
		{
			$nbr++;
			$list[$nbr]= trim( $line );
		}
		else
			$list[$nbr] .= ' '.trim( $line);
	}

	echo "$nbr items read<br>\n";
	$delimText= array( '-' => "logic='up to' ", '/' => "logic='or' ", '&' => "logic='and' ");

	foreach( $list as $nbr => $item)
	{
		$style= '';
		$pos= strpos( $item, '/') or die( "no slash delimiter in item number $nbr");
		$array= explode( '/', trim( substr($item,1)));
		$name= array_shift( $array);
		$data= implode( '/', $array);
		$iId= sprintf( "i%03d", $nbr);

		$array= explode( '<', $name);	//'
		$name= getStyle( parseXMLcoding( trim( array_shift( $array))));
		$author= parseXMLcoding(rtrim( $array[0], "> "));

		if( $style != '' )
		{
			if( $author != '' )
				writeOutLevel( 1, "<$itemTag id='$iId' name='$name' author='$author' style='$style'>");
			else
				writeOutLevel( 1, "<$itemTag id='$iId' name='$name' style='$style' >");
		}
		else
		{
			if( $author != '' )
				writeOutLevel( 1, "<$itemTag id='$iId' name='$name' author='$author' >");
			else
				writeOutLevel( 1, "<$itemTag id='$iId' name='$name' >");
		}

		$comment= array();
		writeLog( "$name = data: $data");
		$data= replaceComment( $data);
		$array= explode( ' ', $data);
		writeLog( "Number of attributes in item: ".count($array));

		foreach( $array as $i =>$attribute )
		{
			if( $attribute == '')
				continue;

			writeLog( "$attribute");
			$split= explode( ',', $attribute);

			if( count($spit) > 2)
				die( "Error: two commas in expression: $attribute");

			$split2= explode( '@', $split[0]);
			$commentCnt= count( $split2) - 1;
			$charNr= (int)$split2[0];
			$attrNbr++;
			$cNbr= sprintf( "%03d", $charNr);
			$aId= sprintf( "a%04d", $attrNbr);

			writeOutLevel( 2, "<$attrTag id='$aId' $charRefTag='c$cNbr'>");		//* attribute open	*//
			$left= FALSE;
			$right= FALSE;

			if( $commentCnt > 2)
				die( "Error: too many comments (>2): $attribute in item number $nbr: ".parseXMLcoding($name));

			if( $commentCnt > 1)
				writeComment( 3, 'left');

			$rest= $split[1];

			if( $rest[0] == '-' && $rest !=  '-' && $rest !=  '-@')
			{
				$delimiter= '-';
				$rest = substr( $rest, 1);
			}
			else
				$delimiter= '';

			if( !$rest )				//** only comment in attribute
			{
				if( $commentCnt)
					writeComment( 3, 'left');

				$commentCnt--;

				if( $commentCnt)
					writeComment( 3, 'right');

				$commentCnt= 0;
			}
			else if( ctype_digit($split[1] ) && !$commentCnt)
				writeOutLevel( 3, "<$attrValueTag value='".$split[1]."' />");
			else if( $rest == '-')
				writeOutLevel( 3, "<$attrValueTag value='-' />");
			else if( $rest == '-@')
			{
				writeLog( "Attribute INAPLICABLE with comment");
				writeOutLevel( 3, "<$attrValueTag value='-'>");
				writeComment(  4, 'right');
				writeOutLevel( 3, "</$attrValueTag>");
			}
			else
			{
				while( $rest)
				{
					if( $delimiter)
						$logic= "logic='".parseXMLcoding($delimiter)."'";
					else
						$logic= '';

					if( $rest[0] == '@')					//* there is comment left to this state
					{
						$rest= substr( $rest, 1);
						$commentCnt= 1;
					}

					$rest= getState( $rest);
					writeOutLevel( 3, "<$attrValueTag $logic value='$state'>");

					if( $commentCnt > 0)
					{
						writeComment( 4, 'left');
						$commentCnt= 0;
					}

					$rest= getDelimiter( $rest);

					if( $delimiter == '@' || $rest == '@')	//* comment to the right of state value
					{
						writeComment( 4, 'right');
						$rest= getDelimiter( $rest);
					}

					if( $delimiter == '@')					//* right comment belonging to the attribute
					{
						$right= TRUE;
						$rest= '';
					}

					writeOutLevel( 3, "</$attrValueTag>");
				}

				if( $right)
					writeComment( 4, 'right');

			}

			writeOutLevel( 2, "</$attrTag>");
		}

		writeOutLevel( 1, "</$itemTag>");

	}

	echo "\nReady, you can open <a href='Delta.xml'>Delta.xml</a> in your browser now.\n</body><html>";
	writeOut("</$itemListTag>\n</DELTA_data>");
	fclose( $file_log);
	fclose( $file_out);
?>